/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.serialize;

import de.willuhn.datasource.serialize.IO;
import de.willuhn.logging.Logger;
import de.willuhn.util.Base64;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractXmlIO
implements IO {
    protected static final String ENCODING = "UTF-8";
    protected static final Map valueMap = new HashMap();

    static {
        valueMap.put(null, new StringValue());
        valueMap.put("java.lang.Double", new DoubleValue());
        valueMap.put("java.math.BigDecimal", new BigDecimalValue());
        valueMap.put("java.lang.Integer", new IntegerValue());
        valueMap.put("java.lang.Long", new LongValue());
        valueMap.put("java.lang.Boolean", new BooleanValue());
        valueMap.put("java.util.Date", new DateValue());
        valueMap.put("java.sql.Date", new SqlDateValue());
        valueMap.put("java.sql.Timestamp", new TimestampValue());
        valueMap.put("[B", new ByteArrayValue());
    }

    protected static class ByteArrayValue
    implements Value {
        protected ByteArrayValue() {
        }

        @Override
        public String serialize(Object o) throws IOException {
            if (o == null) {
                return "";
            }
            if (!(o instanceof byte[])) {
                throw new IOException("unable to serialize " + o);
            }
            return Base64.encode((byte[])((byte[])o));
        }

        @Override
        public Object unserialize(String s) throws IOException {
            if (s == null || s.length() == 0) {
                return null;
            }
            return Base64.decode((String)s);
        }
    }

    protected static class TimestampValue
    extends DateValue {
        protected TimestampValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            java.util.Date date = (java.util.Date)super.unserialize(s);
            return date == null ? null : new Timestamp(date.getTime());
        }
    }

    protected static class SqlDateValue
    extends DateValue {
        protected SqlDateValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            java.util.Date date = (java.util.Date)super.unserialize(s);
            return date == null ? null : new Date(date.getTime());
        }
    }

    protected static class DateValue
    implements Value {
        private static final DateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

        protected DateValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            if (s == null || s.length() == 0) {
                return null;
            }
            try {
                return format.parse(s);
            }
            catch (ParseException e) {
                Logger.error((String)("unable to parse date " + s));
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public String serialize(Object o) throws IOException {
            return o == null ? "" : format.format((java.util.Date)o);
        }
    }

    protected static class BooleanValue
    extends AbstractValue {
        protected BooleanValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            return s != null && (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("1"));
        }
    }

    protected static class LongValue
    extends AbstractValue {
        protected LongValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            return s == null || s.length() == 0 ? null : new Long(s);
        }
    }

    protected static class IntegerValue
    extends AbstractValue {
        protected IntegerValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            return s == null || s.length() == 0 ? null : new Integer(s);
        }
    }

    protected static class BigDecimalValue
    extends AbstractValue {
        protected BigDecimalValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            return s == null || s.length() == 0 ? null : new BigDecimal(s);
        }
    }

    protected static class DoubleValue
    extends AbstractValue {
        protected DoubleValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            return s == null || s.length() == 0 ? null : new Double(s);
        }
    }

    protected static class StringValue
    extends AbstractValue {
        protected StringValue() {
        }

        @Override
        public Object unserialize(String s) throws IOException {
            return s == null ? "" : s;
        }
    }

    protected static abstract class AbstractValue
    implements Value {
        protected AbstractValue() {
        }

        @Override
        public String serialize(Object o) throws IOException {
            return o == null ? "" : o.toString();
        }
    }

    protected static interface Value {
        public String serialize(Object var1) throws IOException;

        public Object unserialize(String var1) throws IOException;
    }
}

